package examples.entity.intro;

import java.util.List;

import javax.ejb.Stateless;
import javax.ejb.Remote;
import javax.persistence.*;

/**
 * Stateless session bean facade for account entities, remotely accessible
 */
@Stateless
@Remote(Bank.class)
@EntityListener(MyListener.class)
public class BankBean implements Bank { 
    /**
     * The entity manager object, injected by the container
     */
    @PersistenceContext
    private EntityManager manager;
    
    public List<Account> listAccounts() {
        //Query query = manager.createQuery("SELECT a FROM Account a");
        Query query = manager.createNamedQuery("findThem");
        return query.getResultList();
    }
    
    public void printBigAccounts() {
        Query query = 
            manager.createQuery("SELECT a FROM Account a WHERE a.balance > 1000");
        
        System.out.println("Got " + query.getResultList().size() + " records.");
        
        // do sth else in the meantime
        try {
            Thread.sleep(15000);
        } catch (InterruptedException e )
        {}
        
        query = 
            manager.createQuery("SELECT a FROM Account a WHERE a.balance > 1000");
        
        System.out.println("Got " + query.getResultList().size() + " records.");
    }

    
    public Account openAccount(String ownerName) {
        Account account = new Account();
        account.ownerName = ownerName;
        System.out.println("Entity belongs to persistence context: " +
                manager.contains(account));
        manager.persist(account);
        System.out.println("Entity belongs to persistence context: " +
                manager.contains(account));
        return account;
    }
    
    public Account openAccount(String ownerName, int accNum) {
        Account account = new Account();
        account.ownerName = ownerName;
        account.accountNumber = accNum;
        System.out.println("Entity belongs to persistence context: " +
                manager.contains(account));
        manager.persist(account);
        System.out.println("Entity belongs to persistence context: " +
                manager.contains(account));
        return account;
    }
    
	public int getBalance(int accountNumber) {
        Account account = manager.find(Account.class, accountNumber);
        return account.balance;
    }
    
    public void deposit(int accountNumber, int amount) {
        Account account = manager.find(Account.class, accountNumber);
        account.balance += amount;
    }
    
    public int withdraw(int accountNumber, int amount) {
        Account account = manager.find(Account.class, accountNumber);
        System.out.println("Withdrawing... " );
        
        account.balance -= amount;
        System.out.println("... amount now... " + account.balance );
        manager.flush();
        return amount;
    }
    
    public void close(int accountNumber) {
        Account account = manager.find(Account.class, accountNumber);
        try {
            Thread.sleep(20000);
        } catch (InterruptedException e )
        {}        
        manager.remove(account);
        try {
            Thread.sleep(20000);
        } catch (InterruptedException e )
        {}
    }
    
    public void update(Account a) {
        manager.merge(a);
    }
    
    public void checkBalance(int accountNumber) {
        System.out.println("Checking... sleep");
        try {
            Thread.sleep(3000);
        } catch (InterruptedException e )
        {}
        Account account = manager.find(Account.class, accountNumber);
        manager.refresh(account);
        int b = account.balance;
        System.out.println("Checking... " + b );
    }
    
}
